/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.ssl.LibPQFactory;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.ObjectFactory;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws RedshiftException {
        String socketFactoryClassName = RedshiftProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return ObjectFactory.instantiate(SocketFactory.class, socketFactoryClassName, info, true, RedshiftProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws RedshiftException {
        String classname = RedshiftProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.amazon.redshift.ssl.jdbc4.LibPQFactory".equals(classname) || "com.amazon.redshift.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            if (classname.equals(RedshiftConnectionImpl.NON_VALIDATING_SSL_FACTORY)) {
                classname = NonValidatingFactory.class.getName();
            }
            return ObjectFactory.instantiate(SSLSocketFactory.class, classname, info, true, RedshiftProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

