/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.AuthMech;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.AmazonRedshiftClientBuilder;
import com.amazonaws.services.redshift.model.DescribeAuthenticationProfilesRequest;
import com.amazonaws.services.redshift.model.DescribeAuthenticationProfilesResult;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class IdpAuthHelper {
    public static final int SAML_PLUGIN = 1;
    public static final int JWT_PLUGIN = 2;

    protected IdpAuthHelper() {
    }

    protected static Properties setAuthProperties(Properties info, RedshiftJDBCSettings settings, RedshiftLogger log) throws RedshiftException {
        try {
            String password;
            String userName;
            if (settings.m_authMech == null || settings.m_authMech.ordinal() < AuthMech.VERIFY_CA.ordinal()) {
                settings.m_authMech = AuthMech.VERIFY_CA;
            }
            String iamAccessKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_ACCESS_KEY_ID.getName(), info);
            String iamSecretKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SECRET_ACCESS_KEY.getName(), info);
            String iamSessionToken = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SESSION_TOKEN.getName(), info);
            String authProfile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AUTH_PROFILE.getName(), info);
            if (!StringUtils.isNullOrEmpty((String)authProfile)) {
                if (!StringUtils.isNullOrEmpty((String)iamAccessKey)) {
                    Properties authProfileProps = IdpAuthHelper.readAuthProfile(authProfile, iamAccessKey, iamSecretKey, iamSessionToken, log, info);
                    if (authProfileProps != null) {
                        authProfileProps.putAll((Map<?, ?>)info);
                        info = authProfileProps;
                    }
                } else {
                    RedshiftException err = new RedshiftException(GT.tr("Dependent connection property setting for {0} is missing {1}", RedshiftProperty.AUTH_PROFILE.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
            }
            if ((userName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.UID.getName(), info)) == null) {
                userName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.USER.getName(), info);
            }
            if ((password = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PWD.getName(), info)) == null) {
                password = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PASSWORD.getName(), info);
            }
            String iamCredentialProvider = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.CREDENTIALS_PROVIDER.getName(), info);
            String iamDisableCache = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_DISABLE_CACHE.getName(), info);
            if (null != userName) {
                settings.m_username = userName;
            }
            if (null != password) {
                settings.m_password = password;
            }
            if (null != iamCredentialProvider) {
                settings.m_credentialsProvider = iamCredentialProvider;
            }
            settings.m_iamDisableCache = iamDisableCache == null ? false : Boolean.valueOf(iamDisableCache);
            Enumeration<?> enums = info.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                String value = info.getProperty(key);
                key = key.toLowerCase(Locale.getDefault());
                if ("*".equals(value)) continue;
                settings.m_pluginArgs.put(key, value);
            }
        }
        catch (RedshiftException re) {
            if (RedshiftLogger.isEnable()) {
                log.logError(re);
            }
            throw re;
        }
        return info;
    }

    private static Properties readAuthProfile(String authProfile, String iamAccessKeyID, String iamSecretKey, String iamSessionToken, RedshiftLogger log, Properties info) throws RedshiftException {
        Properties authProfileProps = null;
        String awsRegion = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_REGION.getName(), info);
        String endpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.ENDPOINT_URL.getName(), info);
        Object credentials = !StringUtils.isNullOrEmpty((String)iamSessionToken) ? new BasicSessionCredentials(iamAccessKeyID, iamSecretKey, iamSessionToken) : new BasicAWSCredentials(iamAccessKeyID, iamSecretKey);
        AWSStaticCredentialsProvider provider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        AmazonRedshiftClientBuilder builder = AmazonRedshiftClientBuilder.standard();
        ClientConfiguration clientConfig = RequestUtils.getProxyClientConfig(log);
        if (clientConfig != null) {
            builder.setClientConfiguration(clientConfig);
        }
        if (endpointUrl != null) {
            AwsClientBuilder.EndpointConfiguration cfg = new AwsClientBuilder.EndpointConfiguration(endpointUrl, awsRegion);
            builder.setEndpointConfiguration(cfg);
        } else if (awsRegion != null && !awsRegion.isEmpty()) {
            builder.setRegion(awsRegion);
        }
        AmazonRedshift client = (AmazonRedshift)((AmazonRedshiftClientBuilder)builder.withCredentials((AWSCredentialsProvider)provider)).build();
        DescribeAuthenticationProfilesRequest request = new DescribeAuthenticationProfilesRequest();
        request.setAuthenticationProfileName(authProfile);
        DescribeAuthenticationProfilesResult result = client.describeAuthenticationProfiles(request);
        String profileContent = result.getAuthenticationProfiles().get(0).getAuthenticationProfileContent();
        authProfileProps = new Properties(info);
        JsonNode profileJson = Jackson.jsonNodeOf((String)profileContent);
        if (profileJson != null) {
            Iterator elements = profileJson.fields();
            while (elements.hasNext()) {
                Map.Entry element = (Map.Entry)elements.next();
                String key = (String)element.getKey();
                String val = ((JsonNode)element.getValue()).asText();
                authProfileProps.put(key, val);
            }
        } else {
            RedshiftException err = new RedshiftException(GT.tr("Auth profile JSON error", new Object[0]), RedshiftState.UNEXPECTED_ERROR);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.ERROR, err.toString(), new Object[0]);
            }
            throw err;
        }
        return authProfileProps;
    }
}

