/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceUtf8;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slices;
import com.amazonaws.athena.jdbc.shaded.spi.type.Type;
import com.amazonaws.athena.jdbc.shaded.spi.type.VarcharType;
import java.util.Objects;

public final class Varchars {
    private Varchars() {
    }

    public static boolean isVarcharType(Type type) {
        return type instanceof VarcharType;
    }

    public static Slice truncateToLength(Slice slice, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (!Varchars.isVarcharType(type)) {
            throw new IllegalArgumentException("type must be the instance of VarcharType");
        }
        return Varchars.truncateToLength(slice, (VarcharType)VarcharType.class.cast(type));
    }

    public static Slice truncateToLength(Slice slice, VarcharType varcharType) {
        Objects.requireNonNull(varcharType, "varcharType is null");
        return Varchars.truncateToLength(slice, varcharType.getLength());
    }

    public static Slice truncateToLength(Slice slice, int maxLength) {
        Objects.requireNonNull(slice, "slice is null");
        if (maxLength < 0) {
            throw new IllegalArgumentException("Max length must be greater or equal than zero");
        }
        if (maxLength == 0) {
            return Slices.EMPTY_SLICE;
        }
        int sizeInBytes = slice.length();
        if (sizeInBytes <= maxLength) {
            return slice;
        }
        int indexEnd = SliceUtf8.offsetOfCodePoint((Slice)slice, (int)maxLength);
        if (indexEnd < 0) {
            return slice;
        }
        return slice.slice(0, indexEnd);
    }
}

