/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.type.AbstractLongType;
import com.amazonaws.athena.jdbc.shaded.spi.type.SqlTimestamp;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;

public final class TimestampType
extends AbstractLongType {
    public static final TimestampType TIMESTAMP = new TimestampType();

    private TimestampType() {
        super(TypeSignature.parseTypeSignature("timestamp"));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlTimestamp(block.getLong(position, 0), session.getTimeZoneKey());
    }

    @Override
    public boolean equals(Object other) {
        return other == TIMESTAMP;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

