/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonValue;
import com.amazonaws.athena.jdbc.shaded.spi.type.DateTimeEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.type.TimeZoneKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.TimeZone;

public final class SqlTimestampWithTimeZone {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS VV");
    private final long millisUtc;
    private final TimeZoneKey timeZoneKey;

    public SqlTimestampWithTimeZone(long timestampWithTimeZone) {
        this.millisUtc = DateTimeEncoding.unpackMillisUtc(timestampWithTimeZone);
        this.timeZoneKey = DateTimeEncoding.unpackZoneKey(timestampWithTimeZone);
    }

    public SqlTimestampWithTimeZone(long millisUtc, TimeZoneKey timeZoneKey) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = timeZoneKey;
    }

    public SqlTimestampWithTimeZone(long millisUtc, TimeZone timeZone) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = TimeZoneKey.getTimeZoneKey(timeZone.getID());
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.timeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimestampWithTimeZone other = (SqlTimestampWithTimeZone)obj;
        return Objects.equals(this.millisUtc, other.millisUtc) && Objects.equals(this.timeZoneKey, other.timeZoneKey);
    }

    @JsonValue
    public String toString() {
        return Instant.ofEpochMilli(this.millisUtc).atZone(ZoneId.of(this.timeZoneKey.getId())).format(formatter);
    }
}

