/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.ErrorCodeSupplier;
import com.amazonaws.athena.jdbc.shaded.spi.PrestoException;
import com.amazonaws.athena.jdbc.shaded.spi.StandardErrorCode;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.type.AbstractIntType;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;

public final class IntegerType
extends AbstractIntType {
    public static final IntegerType INTEGER = new IntegerType();

    private IntegerType() {
        super(TypeSignature.parseTypeSignature("integer"));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getInt(position, 0);
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_INT", value));
        }
        if (value < Integer.MIN_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_INT", value));
        }
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == INTEGER;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

