/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonCreator;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.type.AbstractVariableWidthType;
import com.amazonaws.athena.jdbc.shaded.spi.type.SqlVarbinary;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;

public class HyperLogLogType
extends AbstractVariableWidthType {
    public static final HyperLogLogType HYPER_LOG_LOG = new HyperLogLogType();

    @JsonCreator
    public HyperLogLogType() {
        super(TypeSignature.parseTypeSignature("HyperLogLog"), Slice.class);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlVarbinary(block.getSlice(position, 0, block.getLength(position)).getBytes());
    }
}

