/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.spi.type.CharType;
import com.amazonaws.athena.jdbc.shaded.spi.type.Type;
import com.amazonaws.athena.jdbc.shaded.spi.type.Varchars;
import java.util.Objects;

public final class Chars {
    private Chars() {
    }

    public static boolean isCharType(Type type) {
        return type instanceof CharType;
    }

    public static Slice trimSpacesAndTruncateToLength(Slice slice, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (!Chars.isCharType(type)) {
            throw new IllegalArgumentException("type must be the instance of CharType");
        }
        return Chars.trimSpacesAndTruncateToLength(slice, (CharType)CharType.class.cast(type));
    }

    public static Slice trimSpacesAndTruncateToLength(Slice slice, CharType charType) {
        Objects.requireNonNull(charType, "charType is null");
        return Chars.trimSpacesAndTruncateToLength(slice, charType.getLength());
    }

    public static Slice trimSpacesAndTruncateToLength(Slice slice, int maxLength) {
        Objects.requireNonNull(slice, "slice is null");
        if (maxLength < 0) {
            throw new IllegalArgumentException("Max length must be greater or equal than zero");
        }
        return Varchars.truncateToLength(Chars.trimSpaces(slice), maxLength);
    }

    public static Slice trimSpaces(Slice slice) {
        Objects.requireNonNull(slice, "slice is null");
        return slice.slice(0, Chars.sliceLengthWithoutTrailingSpaces(slice));
    }

    private static int sliceLengthWithoutTrailingSpaces(Slice slice) {
        for (int i = slice.length(); i > 0; --i) {
            if (slice.getByte(i - 1) == 32) continue;
            return i;
        }
        return 0;
    }
}

