/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilderStatus;
import com.amazonaws.athena.jdbc.shaded.spi.block.VariableWidthBlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.type.AbstractType;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;
import com.amazonaws.athena.jdbc.shaded.spi.type.VariableWidthType;

public abstract class AbstractVariableWidthType
extends AbstractType
implements VariableWidthType {
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;

    protected AbstractVariableWidthType(TypeSignature signature, Class<?> javaType) {
        super(signature, javaType);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedBytesPerEntry == 0 ? expectedEntries : Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / expectedBytesPerEntry), expectedBytesPerEntry);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }
}

