/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.transaction;

import com.amazonaws.athena.jdbc.shaded.spi.ErrorCodeSupplier;
import com.amazonaws.athena.jdbc.shaded.spi.PrestoException;
import com.amazonaws.athena.jdbc.shaded.spi.StandardErrorCode;

public enum IsolationLevel {
    SERIALIZABLE,
    REPEATABLE_READ,
    READ_COMMITTED,
    READ_UNCOMMITTED;


    public boolean meetsRequirementOf(IsolationLevel requirement) {
        switch (this) {
            case READ_UNCOMMITTED: {
                return requirement == READ_UNCOMMITTED;
            }
            case READ_COMMITTED: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED;
            }
            case REPEATABLE_READ: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED || requirement == REPEATABLE_READ;
            }
            case SERIALIZABLE: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unhandled isolation level: " + (Object)((Object)this)));
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }

    public static void checkConnectorSupports(IsolationLevel supportedLevel, IsolationLevel requestedLevel) {
        if (!supportedLevel.meetsRequirementOf(requestedLevel)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_ISOLATION_LEVEL, String.format("Connector supported isolation level %s does not meet requested isolation level %s", new Object[]{supportedLevel, requestedLevel}));
        }
    }
}

