/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.security;

import java.security.Principal;
import java.util.Objects;
import java.util.Optional;

public class Identity {
    private final String user;
    private final Optional<Principal> principal;

    public Identity(String user, Optional<Principal> principal) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.user, identity.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Identity{");
        sb.append("user='").append(this.user).append('\'');
        if (this.principal.isPresent()) {
            sb.append(", principal=").append(this.principal.get());
        }
        sb.append('}');
        return sb.toString();
    }
}

