/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.predicate;

import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonSubTypes;
import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonTypeInfo;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.AllOrNoneValueSet;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.DiscreteValues;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.EquatableValueSet;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.Range;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.Ranges;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.SortedRangeSet;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.ValuesProcessor;
import com.amazonaws.athena.jdbc.shaded.spi.type.Type;
import java.util.Collection;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EquatableValueSet.class, name="equatable"), @JsonSubTypes.Type(value=SortedRangeSet.class, name="sortable"), @JsonSubTypes.Type(value=AllOrNoneValueSet.class, name="allOrNone")})
public interface ValueSet {
    public static ValueSet none(Type type) {
        if (type.isOrderable()) {
            return SortedRangeSet.none(type);
        }
        if (type.isComparable()) {
            return EquatableValueSet.none(type);
        }
        return AllOrNoneValueSet.none(type);
    }

    public static ValueSet all(Type type) {
        if (type.isOrderable()) {
            return SortedRangeSet.all(type);
        }
        if (type.isComparable()) {
            return EquatableValueSet.all(type);
        }
        return AllOrNoneValueSet.all(type);
    }

    public static ValueSet of(Type type, Object first, Object ... rest) {
        if (type.isOrderable()) {
            return SortedRangeSet.of(type, first, rest);
        }
        if (type.isComparable()) {
            return EquatableValueSet.of(type, first, rest);
        }
        throw new IllegalArgumentException("Cannot create discrete ValueSet with non-comparable type: " + type);
    }

    public static ValueSet copyOf(Type type, Collection<Object> values) {
        if (type.isOrderable()) {
            return SortedRangeSet.copyOf(type, values.stream().map(value -> Range.equal(type, value)).collect(Collectors.toList()));
        }
        if (type.isComparable()) {
            return EquatableValueSet.copyOf(type, values);
        }
        throw new IllegalArgumentException("Cannot create discrete ValueSet with non-comparable type: " + type);
    }

    public static ValueSet ofRanges(Range first, Range ... rest) {
        return SortedRangeSet.of(first, rest);
    }

    public static ValueSet copyOfRanges(Type type, Collection<Range> ranges) {
        return SortedRangeSet.copyOf(type, ranges);
    }

    public Type getType();

    public boolean isNone();

    public boolean isAll();

    public boolean isSingleValue();

    public Object getSingleValue();

    public boolean containsValue(Object var1);

    default public DiscreteValues getDiscreteValues() {
        throw new UnsupportedOperationException();
    }

    default public Ranges getRanges() {
        throw new UnsupportedOperationException();
    }

    public ValuesProcessor getValuesProcessor();

    public ValueSet intersect(ValueSet var1);

    public ValueSet union(ValueSet var1);

    default public ValueSet union(Collection<ValueSet> valueSets) {
        ValueSet current = this;
        for (ValueSet valueSet : valueSets) {
            current = current.union(valueSet);
        }
        return current;
    }

    public ValueSet complement();

    default public boolean overlaps(ValueSet other) {
        return !this.intersect(other).isNone();
    }

    default public ValueSet subtract(ValueSet other) {
        return this.intersect(other.complement());
    }

    default public boolean contains(ValueSet other) {
        return this.union(other).equals(this);
    }

    public String toString(ConnectorSession var1);
}

