/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.connector.classloader;

import com.amazonaws.athena.jdbc.shaded.spi.ColumnHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorPageSource;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSplit;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import com.amazonaws.athena.jdbc.shaded.spi.connector.ConnectorPageSourceProvider;
import com.amazonaws.athena.jdbc.shaded.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final ConnectorPageSourceProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSourceProvider(ConnectorPageSourceProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorPageSource connectorPageSource = this.delegate.createPageSource(transactionHandle, session, split, columns);
            return connectorPageSource;
        }
    }
}

