/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.connector;

import com.amazonaws.athena.jdbc.shaded.spi.SchemaTableName;
import com.amazonaws.athena.jdbc.shaded.spi.connector.ConnectorTransactionHandle;
import com.amazonaws.athena.jdbc.shaded.spi.security.AccessDeniedException;
import com.amazonaws.athena.jdbc.shaded.spi.security.Identity;
import com.amazonaws.athena.jdbc.shaded.spi.security.Privilege;

public interface ConnectorAccessControl {
    default public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyCreateTable(tableName.toString());
    }

    default public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable(tableName.toString());
    }

    default public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable(tableName.toString(), newTableName.toString());
    }

    default public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn(tableName.toString());
    }

    default public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn(tableName.toString());
    }

    default public void checkCanSelectFromTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denySelectTable(tableName.toString());
    }

    default public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable(tableName.toString());
    }

    default public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable(tableName.toString());
    }

    default public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView(viewName.toString());
    }

    default public void checkCanDropView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyDropView(viewName.toString());
    }

    default public void checkCanSelectFromView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denySelectView(viewName.toString());
    }

    default public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyCreateViewWithSelect(tableName.toString());
    }

    default public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyCreateViewWithSelect(viewName.toString());
    }

    default public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, SchemaTableName tableName) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, SchemaTableName tableName) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), tableName.toString());
    }
}

