/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.classloader;

import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSplitManager;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSplitSource;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorTableLayoutHandle;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;

public final class ClassLoaderSafeConnectorSplitManager
implements ConnectorSplitManager {
    private final ConnectorSplitManager delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorSplitManager(ConnectorSplitManager delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, ConnectorTableLayoutHandle layout) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorSplitSource connectorSplitSource = this.delegate.getSplits(session, layout);
            return connectorSplitSource;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

