/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.classloader;

import com.amazonaws.athena.jdbc.shaded.spi.ConnectorInsertTableHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorOutputTableHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorRecordSinkProvider;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.RecordSink;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;

public final class ClassLoaderSafeConnectorRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final ConnectorRecordSinkProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSinkProvider(ConnectorRecordSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public RecordSink getRecordSink(ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordSink recordSink = this.delegate.getRecordSink(session, tableHandle);
            return recordSink;
        }
    }

    @Override
    public RecordSink getRecordSink(ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordSink recordSink = this.delegate.getRecordSink(session, tableHandle);
            return recordSink;
        }
    }
}

