/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.classloader;

import com.amazonaws.athena.jdbc.shaded.spi.ConnectorInsertTableHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorOutputTableHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorPageSink;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorPageSinkProvider;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ClassLoaderSafeConnectorPageSink;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;

public final class ClassLoaderSafeConnectorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final ConnectorPageSinkProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSinkProvider(ConnectorPageSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(session, outputTableHandle), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(session, insertTableHandle), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }
}

