/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.classloader;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorPageSink;
import com.amazonaws.athena.jdbc.shaded.spi.Page;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ClassLoaderSafeConnectorPageSink
implements ConnectorPageSink {
    private final ConnectorPageSink delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSink(ConnectorPageSink delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public CompletableFuture<?> appendPage(Page page, Block sampleWeightBlock) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture<?> completableFuture = this.delegate.appendPage(page, sampleWeightBlock);
            return completableFuture;
        }
    }

    @Override
    public Collection<Slice> finish() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection<Slice> collection = this.delegate.finish();
            return collection;
        }
    }

    @Override
    public void abort() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

