/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.classloader;

import com.amazonaws.athena.jdbc.shaded.spi.ColumnHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorIndex;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorIndexHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorIndexResolver;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorResolvedIndex;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorTableHandle;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ClassLoaderSafeConnectorIndexResolver
implements ConnectorIndexResolver {
    private final ConnectorIndexResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorIndexResolver(ConnectorIndexResolver delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorResolvedIndex resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorResolvedIndex connectorResolvedIndex = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return connectorResolvedIndex;
        }
    }

    @Override
    public ConnectorResolvedIndex resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorResolvedIndex connectorResolvedIndex = this.delegate.resolveIndex(session, tableHandle, indexableColumns, tupleDomain);
            return connectorResolvedIndex;
        }
    }

    @Override
    public ConnectorIndex getIndex(ConnectorSession session, ConnectorIndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorIndex connectorIndex = this.delegate.getIndex(session, indexHandle, lookupSchema, outputSchema);
            return connectorIndex;
        }
    }
}

