/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.EncoderUtil;
import com.amazonaws.athena.jdbc.shaded.spi.block.ShortArrayBlock;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;

public class ShortArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<ShortArrayBlockEncoding> FACTORY = new ShortArrayBlockEncodingFactory();
    private static final String NAME = "SHORT_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeShort((int)block.getShort(position, 0));
        }
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        short[] values = new short[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull[position]) continue;
            values[position] = sliceInput.readShort();
        }
        return new ShortArrayBlock(positionCount, valueIsNull, values);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class ShortArrayBlockEncodingFactory
    implements BlockEncodingFactory<ShortArrayBlockEncoding> {
        @Override
        public String getName() {
            return ShortArrayBlockEncoding.NAME;
        }

        @Override
        public ShortArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new ShortArrayBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, ShortArrayBlockEncoding blockEncoding) {
        }
    }
}

