/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.RunLengthEncodedBlock;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;
import java.util.Objects;

public class RunLengthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<RunLengthBlockEncoding> FACTORY = new RunLengthBlockEncodingFactory();
    private static final String NAME = "RLE";
    private final BlockEncoding valueBlockEncoding;

    public RunLengthBlockEncoding(BlockEncoding valueBlockEncoding) {
        this.valueBlockEncoding = Objects.requireNonNull(valueBlockEncoding, "valueBlockEncoding is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    public BlockEncoding getValueBlockEncoding() {
        return this.valueBlockEncoding;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block;
        sliceOutput.writeInt(rleBlock.getPositionCount());
        this.getValueBlockEncoding().writeBlock(sliceOutput, rleBlock.getValue());
    }

    @Override
    public RunLengthEncodedBlock readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block value = this.getValueBlockEncoding().readBlock(sliceInput);
        return new RunLengthEncodedBlock(value, positionCount);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    private static class RunLengthBlockEncodingFactory
    implements BlockEncodingFactory<RunLengthBlockEncoding> {
        private RunLengthBlockEncodingFactory() {
        }

        @Override
        public String getName() {
            return RunLengthBlockEncoding.NAME;
        }

        @Override
        public RunLengthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new RunLengthBlockEncoding(valueBlockEncoding);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, RunLengthBlockEncoding blockEncoding) {
            serde.writeBlockEncoding(output, blockEncoding.getValueBlockEncoding());
        }
    }
}

