/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilderStatus;

public class PageBuilderStatus {
    public static final int DEFAULT_MAX_PAGE_SIZE_IN_BYTES = 0x100000;
    private final int maxPageSizeInBytes;
    private final int maxBlockSizeInBytes;
    private boolean full;
    private int currentSize;

    public PageBuilderStatus() {
        this(0x100000, 65536);
    }

    public PageBuilderStatus(int maxPageSizeInBytes, int maxBlockSizeInBytes) {
        this.maxPageSizeInBytes = maxPageSizeInBytes;
        this.maxBlockSizeInBytes = maxBlockSizeInBytes;
    }

    public BlockBuilderStatus createBlockBuilderStatus() {
        return new BlockBuilderStatus(this, this.maxBlockSizeInBytes);
    }

    public int getMaxBlockSizeInBytes() {
        return this.maxBlockSizeInBytes;
    }

    public int getMaxPageSizeInBytes() {
        return this.maxPageSizeInBytes;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public boolean isFull() {
        return this.full || this.currentSize >= this.maxPageSizeInBytes;
    }

    void setFull() {
        this.full = true;
    }

    void addBytes(int bytes) {
        this.currentSize += bytes;
    }

    public int getSizeInBytes() {
        return this.currentSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append("maxSizeInBytes=").append(this.maxPageSizeInBytes);
        buffer.append(", full=").append(this.full);
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }
}

