/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.LazyBlock;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;

public class LazyBlockEncoding
implements BlockEncoding {
    private final BlockEncoding delegate;

    public LazyBlockEncoding(BlockEncoding delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        this.delegate.writeBlock(sliceOutput, ((LazyBlock)block).getBlock());
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return new LazyBlockEncodingFactory(this.delegate.getFactory());
    }

    public static class LazyBlockEncodingFactory
    implements BlockEncodingFactory<LazyBlockEncoding> {
        private final BlockEncodingFactory delegate;

        public LazyBlockEncodingFactory(BlockEncodingFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public LazyBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, LazyBlockEncoding blockEncoding) {
            this.delegate.writeEncoding(serde, output, blockEncoding.delegate);
        }
    }
}

