/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SizeOf;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockUtil;
import com.amazonaws.athena.jdbc.shaded.spi.block.IntArrayBlockEncoding;
import java.util.Arrays;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class IntArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntArrayBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final int[] values;
    private final int sizeInBytes;
    private final int retainedSizeInBytes;

    public IntArrayBlock(int positionCount, boolean[] valueIsNull, int[] values) {
        this(0, positionCount, valueIsNull, values);
    }

    IntArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, int[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = BlockUtil.intSaturatedCast(5L * (long)positionCount);
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])values));
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        return 4;
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return this.values[position + this.arrayOffset];
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeInt(this.values[position + this.arrayOffset]);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return new IntArrayBlock(1, new boolean[]{this.valueIsNull[position + this.arrayOffset]}, new int[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        boolean[] newValueIsNull = new boolean[positions.size()];
        int[] newValues = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            this.checkReadablePosition(position);
            newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new IntArrayBlock(positions.size(), newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new IntArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset += this.arrayOffset, positionOffset + length);
        int[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new IntArrayBlock(length, newValueIsNull, newValues);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new IntArrayBlockEncoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

