/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slices;
import com.amazonaws.athena.jdbc.shaded.spi.block.AbstractFixedWidthBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.EncoderUtil;
import com.amazonaws.athena.jdbc.shaded.spi.block.FixedWidthBlock;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;

public class FixedWidthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<FixedWidthBlockEncoding> FACTORY = new FixedWidthBlockEncodingFactory();
    private static final String NAME = "FIXED_WIDTH";
    private final int fixedSize;

    public FixedWidthBlockEncoding(int fixedSize) {
        if (fixedSize < 0) {
            throw new IllegalArgumentException("fixedSize is negative");
        }
        this.fixedSize = fixedSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractFixedWidthBlock fixedWidthBlock = (AbstractFixedWidthBlock)block;
        int positionCount = fixedWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, fixedWidthBlock);
        Slice slice = fixedWidthBlock.getRawSlice();
        sliceOutput.appendInt(slice.length()).writeBytes(slice);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new FixedWidthBlock(this.fixedSize, positionCount, slice, Slices.wrappedBooleanArray((boolean[])valueIsNull));
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class FixedWidthBlockEncodingFactory
    implements BlockEncodingFactory<FixedWidthBlockEncoding> {
        @Override
        public String getName() {
            return FixedWidthBlockEncoding.NAME;
        }

        @Override
        public FixedWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            int entrySize = input.readInt();
            return new FixedWidthBlockEncoding(entrySize);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, FixedWidthBlockEncoding blockEncoding) {
            output.writeInt(blockEncoding.getFixedSize());
        }
    }
}

