/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slices;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.XxHash64;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.VariableWidthBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.VariableWidthBlockEncoding;

public abstract class AbstractVariableWidthBlock
implements Block {
    protected abstract Slice getRawSlice(int var1);

    protected abstract int getPositionOffset(int var1);

    protected abstract boolean isEntryNull(int var1);

    @Override
    public BlockEncoding getEncoding() {
        return new VariableWidthBlockEncoding();
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getByte(this.getPositionOffset(position) + offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getShort(this.getPositionOffset(position) + offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getInt(this.getPositionOffset(position) + offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getLong(this.getPositionOffset(position) + offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).slice(this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkReadablePosition(position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getLength(position) < length) {
            return false;
        }
        return otherBlock.bytesEqual(otherPosition, otherOffset, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).equals(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return XxHash64.hash((Slice)this.getRawSlice(position), (int)(this.getPositionOffset(position) + offset), (int)length);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getLength(position) < length) {
            throw new IllegalArgumentException("Length longer than value length");
        }
        return -otherBlock.bytesCompare(otherPosition, otherOffset, otherLength, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).compareTo(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeBytes(this.getRawSlice(position), this.getPositionOffset(position) + offset, length);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.writeBytesTo(position, 0, this.getLength(position), blockBuilder);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
        }
        int offset = this.getPositionOffset(position);
        int entrySize = this.getLength(position);
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(position), (int)offset, (int)entrySize);
        return new VariableWidthBlock(1, copy, new int[]{0, copy.length()}, new boolean[]{false});
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryNull(position);
    }

    protected void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

