/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi;

import com.amazonaws.athena.jdbc.shaded.spi.Page;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.block.PageBuilderStatus;
import com.amazonaws.athena.jdbc.shaded.spi.type.FixedWidthType;
import com.amazonaws.athena.jdbc.shaded.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class PageBuilder {
    private final BlockBuilder[] blockBuilders;
    private final List<Type> types;
    private final int initialExpectedEntries;
    private PageBuilderStatus pageBuilderStatus;
    private int declaredPositions;

    public PageBuilder(List<? extends Type> types) {
        this(Integer.MAX_VALUE, types);
    }

    public PageBuilder(int initialExpectedEntries, List<? extends Type> types) {
        this(initialExpectedEntries, 0x100000, types);
    }

    public static PageBuilder withMaxPageSize(int maxPageBytes, List<? extends Type> types) {
        return new PageBuilder(Integer.MAX_VALUE, maxPageBytes, types);
    }

    private PageBuilder(int initialExpectedEntries, int maxPageBytes, List<? extends Type> types) {
        int maxBlockSizeInBytes;
        this.types = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(types, "types is null")));
        if (!types.isEmpty()) {
            maxBlockSizeInBytes = (int)(1.0 * (double)maxPageBytes / (double)types.size());
            maxBlockSizeInBytes = Math.min(65536, maxBlockSizeInBytes);
        } else {
            maxBlockSizeInBytes = 0;
        }
        this.pageBuilderStatus = new PageBuilderStatus(maxPageBytes, maxBlockSizeInBytes);
        int expectedEntries = Math.min(maxBlockSizeInBytes, initialExpectedEntries);
        for (Type type : types) {
            if (type instanceof FixedWidthType) {
                int fixedSize = Math.max(((FixedWidthType)type).getFixedSize(), 1);
                expectedEntries = Math.min(expectedEntries, maxBlockSizeInBytes / fixedSize);
                continue;
            }
            expectedEntries = Math.min(expectedEntries, maxBlockSizeInBytes / 32);
        }
        this.blockBuilders = new BlockBuilder[types.size()];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), expectedEntries, this.pageBuilderStatus.getMaxBlockSizeInBytes() / expectedEntries);
        }
        this.initialExpectedEntries = expectedEntries;
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.pageBuilderStatus = new PageBuilderStatus(this.pageBuilderStatus.getMaxPageSizeInBytes(), this.pageBuilderStatus.getMaxBlockSizeInBytes());
        this.declaredPositions = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            this.blockBuilders[i].reset(this.pageBuilderStatus.createBlockBuilderStatus());
        }
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public void declarePositions(int positions) {
        this.declaredPositions = positions;
    }

    public boolean isFull() {
        return this.declaredPositions == Integer.MAX_VALUE || this.pageBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public long getSizeInBytes() {
        return this.pageBuilderStatus.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return Stream.of(this.blockBuilders).mapToLong(Block::getRetainedSizeInBytes).sum();
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions, new Block[0]);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
            if (blocks[i].getPositionCount() == this.declaredPositions) continue;
            throw new IllegalStateException(String.format("Declared positions (%s) does not match block %s's number of entries (%s)", this.declaredPositions, i, blocks[i].getPositionCount()));
        }
        return new Page(blocks);
    }
}

