/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi;

import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonCreator;
import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonProperty;
import com.amazonaws.athena.jdbc.shaded.spi.ErrorType;
import java.util.Objects;

public final class ErrorCode {
    private final int code;
    private final String name;
    private final ErrorType type;

    @JsonCreator
    public ErrorCode(@JsonProperty(value="code") int code, @JsonProperty(value="name") String name, @JsonProperty(value="type") ErrorType type) {
        if (code < 0) {
            throw new IllegalArgumentException("code is negative");
        }
        this.code = code;
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public int getCode() {
        return this.code;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public ErrorType getType() {
        return this.type;
    }

    public String toString() {
        return this.name + ":" + this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorCode that = (ErrorCode)obj;
        return Objects.equals(this.code, that.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }
}

