/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi;

import com.amazonaws.athena.jdbc.shaded.spi.NotFoundException;
import com.amazonaws.athena.jdbc.shaded.spi.SchemaTableName;

public class ColumnNotFoundException
extends NotFoundException {
    private final SchemaTableName tableName;
    private final String columnName;

    public ColumnNotFoundException(SchemaTableName tableName, String columnName) {
        this(tableName, columnName, "Column " + columnName + " not found in table " + tableName);
    }

    public ColumnNotFoundException(SchemaTableName tableName, String columnName, String message) {
        super(message);
        if (tableName == null) {
            throw new NullPointerException("tableName is null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName is null");
        }
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public ColumnNotFoundException(SchemaTableName tableName, String columnName, Throwable cause) {
        this(tableName, columnName, "Table " + tableName + " not found", cause);
    }

    public ColumnNotFoundException(SchemaTableName tableName, String columnName, String message, Throwable cause) {
        super(message, cause);
        if (tableName == null) {
            throw new NullPointerException("tableName is null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName is null");
        }
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

