/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.std;

import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonFormat;
import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonGenerator;
import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonParser;
import com.amazonaws.athena.jdbc.shaded.jackson.core.SerializableString;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.BeanDescription;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.BeanProperty;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JavaType;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonMappingException;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonNode;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonSerializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.SerializationConfig;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.SerializationFeature;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.SerializerProvider;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.annotation.JacksonStdImpl;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.node.ArrayNode;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.node.ObjectNode;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.ContextualSerializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.ser.std.StdScalarSerializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    @Deprecated
    public EnumSerializer(EnumValues v) {
        this(v, null);
    }

    public EnumSerializer(EnumValues v, Boolean serializeAsIndex) {
        super(v.getEnumClass(), false);
        this._values = v;
        this._serializeAsIndex = serializeAsIndex;
    }

    public static EnumSerializer construct(Class<?> enumClass, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format) {
        EnumValues v = EnumValues.constructFromName(config, enumClass);
        Boolean serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(enumClass, format, true);
        return new EnumSerializer(v, serializeAsIndex);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Boolean serializeAsIndex;
        JsonFormat.Value format;
        if (property != null && (format = prov.getAnnotationIntrospector().findFormat(property.getMember())) != null && (serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(property.getType().getRawClass(), format, false)) != this._serializeAsIndex) {
            return new EnumSerializer(this._values, serializeAsIndex);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this._serializeAsIndex(serializers)) {
            gen.writeNumber(en.ordinal());
            return;
        }
        if (serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            gen.writeString(en.toString());
            return;
        }
        gen.writeString(this._values.serializedValueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        JavaType type;
        if (this._serializeAsIndex(provider)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type = provider.constructType(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (SerializableString value : this._values.values()) {
                enumNode.add(value.getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        SerializerProvider serializers = visitor.getProvider();
        if (this._serializeAsIndex(serializers)) {
            JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
            if (v2 != null) {
                v2.numberType(JsonParser.NumberType.INT);
            }
            return;
        }
        boolean usingToString = serializers != null && serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
        if (typeHint != null && stringVisitor != null) {
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            for (SerializableString value : this._values.values()) {
                if (usingToString) {
                    enums.add(value.toString());
                    continue;
                }
                enums.add(value.getValue());
            }
            stringVisitor.enumTypes(enums);
        }
    }

    protected final boolean _serializeAsIndex(SerializerProvider serializers) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> enumClass, JsonFormat.Value format, boolean fromClass) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = format == null ? null : format.getShape();
        if (shape == null) {
            return null;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return null;
        }
        if (shape == JsonFormat.Shape.STRING) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric() || shape == JsonFormat.Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("Unsupported serialization shape (" + (Object)((Object)shape) + ") for Enum " + enumClass.getName() + ", not supported as " + (fromClass ? "class" : "property") + " annotation");
    }
}

