/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.jackson.databind.deser.std;

import com.amazonaws.athena.jdbc.shaded.jackson.databind.BeanDescription;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.DeserializationConfig;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JavaType;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonMappingException;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.KeyDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.deser.KeyDeserializers;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.deser.std.StdKeyDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.util.ClassUtil;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type) {
        Object beanDesc = config.introspect(type);
        Constructor<?> ctor = ((BeanDescription)beanDesc).findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor);
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = ((BeanDescription)beanDesc).findFactoryMethod(String.class);
        if (m != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m);
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

