/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.jackson.databind.deser.std;

import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonParser;
import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonToken;
import com.amazonaws.athena.jdbc.shaded.jackson.core.io.NumberInput;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.AnnotationIntrospector;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.BeanProperty;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.DeserializationContext;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.DeserializationFeature;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JavaType;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.JsonMappingException;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.KeyDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.jsontype.TypeDeserializer;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.util.ClassUtil;
import com.amazonaws.athena.jdbc.shaded.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? null : valueType.getRawClass();
    }

    protected StdDeserializer(StdDeserializer<?> src) {
        this._valueClass = src._valueClass;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return ClassUtil.isJacksonStdImpl(deserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return ClassUtil.isJacksonStdImpl(keyDeser);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() != 0;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text) || text.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text)) {
                return false;
            }
            throw ctxt.weirdStringException(text, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            boolean parsed = this._parseBooleanPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'boolean' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Boolean _parseBoolean(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return Boolean.TRUE;
            }
            if ("false".equals(text) || "False".equals(text)) {
                return Boolean.FALSE;
            }
            if (text.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            if (this._hasTextualNull(text)) {
                return (Boolean)this.getNullValue();
            }
            throw ctxt.weirdStringException(text, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Boolean parsed = this._parseBoolean(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Boolean' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final boolean _parseBooleanFromNumber(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getNumberType() == JsonParser.NumberType.LONG) {
            return jp.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String str = jp.getText();
        if ("0.0".equals(str) || "0".equals(str)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Byte _parseByte(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getByteValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = jp.getText().trim();
            if (this._hasTextualNull(text)) {
                return (Byte)this.getNullValue();
            }
            try {
                int len = text.length();
                if (len == 0) {
                    return (Byte)this.getEmptyValue();
                }
                value = NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Byte value");
            }
            if (value < -128 || value > 255) {
                throw ctxt.weirdStringException(text, this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Byte parsed = this._parseByte(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Byte' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Short _parseShort(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getShortValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len == 0) {
                    return (Short)this.getEmptyValue();
                }
                if (this._hasTextualNull(text)) {
                    return (Short)this.getNullValue();
                }
                value = NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Short value");
            }
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw ctxt.weirdStringException(text, this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Short parsed = this._parseShort(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Short' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final short _parseShortPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        int value = this._parseIntPrimitive(jp, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw ctxt.weirdStringException(String.valueOf(value), this._valueClass, "overflow, value can not be represented as 16-bit value");
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (this._hasTextualNull(text)) {
                return 0;
            }
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(text, this._valueClass, "Overflow: numeric value (" + text + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid int value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            int parsed = this._parseIntPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'int' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Integer _parseInteger(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (this._hasTextualNull(text)) {
                    return (Integer)this.getNullValue();
                }
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(text, this._valueClass, "Overflow: numeric value (" + text + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return (Integer)this.getEmptyValue();
                }
                return NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Integer value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Integer)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Integer parsed = this._parseInteger(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Integer' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Long _parseLong(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getLongValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return (Long)this.getEmptyValue();
            }
            if (this._hasTextualNull(text)) {
                return (Long)this.getNullValue();
            }
            try {
                return NumberInput.parseLong(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Long value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Long)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Long parsed = this._parseLong(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Long' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final long _parseLongPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getLongValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0L;
            }
            try {
                return NumberInput.parseLong(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid long value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0L;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            long parsed = this._parseLongPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'long' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Float _parseFloat(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jp.getFloatValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return (Float)this.getEmptyValue();
            }
            if (this._hasTextualNull(text)) {
                return (Float)this.getNullValue();
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Float value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Float parsed = this._parseFloat(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Byte' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final float _parseFloatPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getFloatValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0.0f;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid float value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            float parsed = this._parseFloatPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'float' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Double _parseDouble(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return (Double)this.getEmptyValue();
            }
            if (this._hasTextualNull(text)) {
                return (Double)this.getNullValue();
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Double value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Double parsed = this._parseDouble(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Double' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final double _parseDoublePrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0.0;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid double value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            double parsed = this._parseDoublePrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Byte' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Date _parseDate(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jp.getLongValue());
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String value = null;
            try {
                value = jp.getText().trim();
                if (value.length() == 0) {
                    return (Date)this.getEmptyValue();
                }
                if (this._hasTextualNull(value)) {
                    return (Date)this.getNullValue();
                }
                return ctxt.parseDate(value);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(value, this._valueClass, "not a valid representation (error: " + iae.getMessage() + ")");
            }
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Date parsed = this._parseDate(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'java.util.Date' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected static final double parseDouble(String numStr) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(numStr);
    }

    protected final String _parseString(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            return jp.getText();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            String parsed = this._parseString(jp, ctxt);
            if (jp.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'String' value but there was more than a single value in the array");
            }
            return parsed;
        }
        String value = jp.getValueAsString();
        if (value != null) {
            return value;
        }
        throw ctxt.mappingException(String.class, jp.getCurrentToken());
    }

    protected T _deserializeFromEmpty(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String str;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_ARRAY) {
            if (ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                t = jp.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    return null;
                }
                throw ctxt.mappingException(this.handledType(), JsonToken.START_ARRAY);
            }
        } else if (t == JsonToken.VALUE_STRING && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = jp.getText().trim()).isEmpty()) {
            return null;
        }
        throw ctxt.mappingException(this.handledType());
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected final boolean _isNegInf(String text) {
        return "-Infinity".equals(text) || "-INF".equals(text);
    }

    protected final boolean _isPosInf(String text) {
        return "Infinity".equals(text) || "INF".equals(text);
    }

    protected final boolean _isNaN(String text) {
        return "NaN".equals(text);
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type, BeanProperty property) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type, property);
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> existingDeserializer) throws JsonMappingException {
        Object convDef;
        AnnotatedMember member;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && prop != null && (member = prop.getMember()) != null && (convDef = intr.findDeserializationContentConverter(member)) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (existingDeserializer == null) {
                existingDeserializer = ctxt.findContextualValueDeserializer(delegateType, prop);
            }
            return new StdDelegatingDeserializer<Object>(conv, delegateType, existingDeserializer);
        }
        return existingDeserializer;
    }

    protected void handleUnknownProperty(JsonParser jp, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException {
        if (instanceOrClass == null) {
            instanceOrClass = this.handledType();
        }
        if (ctxt.handleUnknownProperty(jp, this, instanceOrClass, propName)) {
            return;
        }
        ctxt.reportUnknownProperty(instanceOrClass, propName, this);
        jp.skipChildren();
    }
}

