/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.BinaryColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.BooleanColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.ColumnStatistics;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.ColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.DateColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Decimal;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.DecimalColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.DoubleColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.LongColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.StringColumnStatisticsData;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.UpdateColumnStatisticsForTableRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateColumnStatisticsForTableRequestMarshaller
implements Marshaller<Request<UpdateColumnStatisticsForTableRequest>, UpdateColumnStatisticsForTableRequest> {
    @Override
    public Request<UpdateColumnStatisticsForTableRequest> marshall(UpdateColumnStatisticsForTableRequest updateColumnStatisticsForTableRequest) {
        if (updateColumnStatisticsForTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateColumnStatisticsForTableRequest> request = new DefaultRequest<UpdateColumnStatisticsForTableRequest>(updateColumnStatisticsForTableRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.UpdateColumnStatisticsForTable";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag columnStatisticsListList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateColumnStatisticsForTableRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)updateColumnStatisticsForTableRequest.getCatalogId());
            }
            if (updateColumnStatisticsForTableRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)updateColumnStatisticsForTableRequest.getNamespaceName());
            }
            if (updateColumnStatisticsForTableRequest.getTableName() != null) {
                jsonWriter.key("tableName").value((Object)updateColumnStatisticsForTableRequest.getTableName());
            }
            if (updateColumnStatisticsForTableRequest.getAnalyzedTime() != null) {
                jsonWriter.key("analyzedTime").value(updateColumnStatisticsForTableRequest.getAnalyzedTime());
            }
            if (!((columnStatisticsListList = (ListWithAutoConstructFlag)updateColumnStatisticsForTableRequest.getColumnStatisticsList()) == null || columnStatisticsListList.isAutoConstruct() && columnStatisticsListList.isEmpty())) {
                jsonWriter.key("columnStatisticsList");
                jsonWriter.array();
                for (ColumnStatistics columnStatisticsListListValue : columnStatisticsListList) {
                    ColumnStatisticsData statisticsData;
                    if (columnStatisticsListListValue == null) continue;
                    jsonWriter.object();
                    if (columnStatisticsListListValue.getColumnName() != null) {
                        jsonWriter.key("columnName").value((Object)columnStatisticsListListValue.getColumnName());
                    }
                    if (columnStatisticsListListValue.getColumnType() != null) {
                        jsonWriter.key("columnType").value((Object)columnStatisticsListListValue.getColumnType());
                    }
                    if (columnStatisticsListListValue.getAnalyzedTime() != null) {
                        jsonWriter.key("analyzedTime").value(columnStatisticsListListValue.getAnalyzedTime());
                    }
                    if ((statisticsData = columnStatisticsListListValue.getStatisticsData()) != null) {
                        BinaryColumnStatisticsData binaryColumnStatisticsData;
                        StringColumnStatisticsData stringColumnStatisticsData;
                        LongColumnStatisticsData longColumnStatisticsData;
                        DoubleColumnStatisticsData doubleColumnStatisticsData;
                        DecimalColumnStatisticsData decimalColumnStatisticsData;
                        DateColumnStatisticsData dateColumnStatisticsData;
                        BooleanColumnStatisticsData booleanColumnStatisticsData;
                        jsonWriter.key("statisticsData");
                        jsonWriter.object();
                        if (statisticsData.getType() != null) {
                            jsonWriter.key("type").value((Object)statisticsData.getType());
                        }
                        if ((booleanColumnStatisticsData = statisticsData.getBooleanColumnStatisticsData()) != null) {
                            jsonWriter.key("booleanColumnStatisticsData");
                            jsonWriter.object();
                            if (booleanColumnStatisticsData.getNumberOfTrues() != null) {
                                jsonWriter.key("numberOfTrues").value((Object)booleanColumnStatisticsData.getNumberOfTrues());
                            }
                            if (booleanColumnStatisticsData.getNumberOfFalses() != null) {
                                jsonWriter.key("numberOfFalses").value((Object)booleanColumnStatisticsData.getNumberOfFalses());
                            }
                            if (booleanColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)booleanColumnStatisticsData.getNumberOfNulls());
                            }
                            jsonWriter.endObject();
                        }
                        if ((dateColumnStatisticsData = statisticsData.getDateColumnStatisticsData()) != null) {
                            jsonWriter.key("dateColumnStatisticsData");
                            jsonWriter.object();
                            if (dateColumnStatisticsData.getMinimumValue() != null) {
                                jsonWriter.key("minimumValue").value(dateColumnStatisticsData.getMinimumValue());
                            }
                            if (dateColumnStatisticsData.getMaximumValue() != null) {
                                jsonWriter.key("maximumValue").value(dateColumnStatisticsData.getMaximumValue());
                            }
                            if (dateColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)dateColumnStatisticsData.getNumberOfNulls());
                            }
                            if (dateColumnStatisticsData.getNumberOfDistinctValues() != null) {
                                jsonWriter.key("numberOfDistinctValues").value((Object)dateColumnStatisticsData.getNumberOfDistinctValues());
                            }
                            jsonWriter.endObject();
                        }
                        if ((decimalColumnStatisticsData = statisticsData.getDecimalColumnStatisticsData()) != null) {
                            Decimal maximumValue;
                            jsonWriter.key("decimalColumnStatisticsData");
                            jsonWriter.object();
                            Decimal minimumValue = decimalColumnStatisticsData.getMinimumValue();
                            if (minimumValue != null) {
                                jsonWriter.key("minimumValue");
                                jsonWriter.object();
                                if (minimumValue.getUnscaledValue() != null) {
                                    jsonWriter.key("unscaledValue").value(minimumValue.getUnscaledValue());
                                }
                                if (minimumValue.getScale() != null) {
                                    jsonWriter.key("scale").value((Object)minimumValue.getScale());
                                }
                                jsonWriter.endObject();
                            }
                            if ((maximumValue = decimalColumnStatisticsData.getMaximumValue()) != null) {
                                jsonWriter.key("maximumValue");
                                jsonWriter.object();
                                if (maximumValue.getUnscaledValue() != null) {
                                    jsonWriter.key("unscaledValue").value(maximumValue.getUnscaledValue());
                                }
                                if (maximumValue.getScale() != null) {
                                    jsonWriter.key("scale").value((Object)maximumValue.getScale());
                                }
                                jsonWriter.endObject();
                            }
                            if (decimalColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)decimalColumnStatisticsData.getNumberOfNulls());
                            }
                            if (decimalColumnStatisticsData.getNumberOfDistinctValues() != null) {
                                jsonWriter.key("numberOfDistinctValues").value((Object)decimalColumnStatisticsData.getNumberOfDistinctValues());
                            }
                            jsonWriter.endObject();
                        }
                        if ((doubleColumnStatisticsData = statisticsData.getDoubleColumnStatisticsData()) != null) {
                            jsonWriter.key("doubleColumnStatisticsData");
                            jsonWriter.object();
                            if (doubleColumnStatisticsData.getMinimumValue() != null) {
                                jsonWriter.key("minimumValue").value((Object)doubleColumnStatisticsData.getMinimumValue());
                            }
                            if (doubleColumnStatisticsData.getMaximumValue() != null) {
                                jsonWriter.key("maximumValue").value((Object)doubleColumnStatisticsData.getMaximumValue());
                            }
                            if (doubleColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)doubleColumnStatisticsData.getNumberOfNulls());
                            }
                            if (doubleColumnStatisticsData.getNumberOfDistinctValues() != null) {
                                jsonWriter.key("numberOfDistinctValues").value((Object)doubleColumnStatisticsData.getNumberOfDistinctValues());
                            }
                            jsonWriter.endObject();
                        }
                        if ((longColumnStatisticsData = statisticsData.getLongColumnStatisticsData()) != null) {
                            jsonWriter.key("longColumnStatisticsData");
                            jsonWriter.object();
                            if (longColumnStatisticsData.getMinimumValue() != null) {
                                jsonWriter.key("minimumValue").value((Object)longColumnStatisticsData.getMinimumValue());
                            }
                            if (longColumnStatisticsData.getMaximumValue() != null) {
                                jsonWriter.key("maximumValue").value((Object)longColumnStatisticsData.getMaximumValue());
                            }
                            if (longColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)longColumnStatisticsData.getNumberOfNulls());
                            }
                            if (longColumnStatisticsData.getNumberOfDistinctValues() != null) {
                                jsonWriter.key("numberOfDistinctValues").value((Object)longColumnStatisticsData.getNumberOfDistinctValues());
                            }
                            jsonWriter.endObject();
                        }
                        if ((stringColumnStatisticsData = statisticsData.getStringColumnStatisticsData()) != null) {
                            jsonWriter.key("stringColumnStatisticsData");
                            jsonWriter.object();
                            if (stringColumnStatisticsData.getMaximumLength() != null) {
                                jsonWriter.key("maximumLength").value((Object)stringColumnStatisticsData.getMaximumLength());
                            }
                            if (stringColumnStatisticsData.getAverageLength() != null) {
                                jsonWriter.key("averageLength").value((Object)stringColumnStatisticsData.getAverageLength());
                            }
                            if (stringColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)stringColumnStatisticsData.getNumberOfNulls());
                            }
                            if (stringColumnStatisticsData.getNumberOfDistinctValues() != null) {
                                jsonWriter.key("numberOfDistinctValues").value((Object)stringColumnStatisticsData.getNumberOfDistinctValues());
                            }
                            jsonWriter.endObject();
                        }
                        if ((binaryColumnStatisticsData = statisticsData.getBinaryColumnStatisticsData()) != null) {
                            jsonWriter.key("binaryColumnStatisticsData");
                            jsonWriter.object();
                            if (binaryColumnStatisticsData.getMaximumLength() != null) {
                                jsonWriter.key("maximumLength").value((Object)binaryColumnStatisticsData.getMaximumLength());
                            }
                            if (binaryColumnStatisticsData.getAverageLength() != null) {
                                jsonWriter.key("averageLength").value((Object)binaryColumnStatisticsData.getAverageLength());
                            }
                            if (binaryColumnStatisticsData.getNumberOfNulls() != null) {
                                jsonWriter.key("numberOfNulls").value((Object)binaryColumnStatisticsData.getNumberOfNulls());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

