/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.EntityDescription;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.GetPrivilegesRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class GetPrivilegesRequestMarshaller
implements Marshaller<Request<GetPrivilegesRequest>, GetPrivilegesRequest> {
    @Override
    public Request<GetPrivilegesRequest> marshall(GetPrivilegesRequest getPrivilegesRequest) {
        if (getPrivilegesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPrivilegesRequest> request = new DefaultRequest<GetPrivilegesRequest>(getPrivilegesRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.GetPrivileges";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            EntityDescription catalogEntity;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (getPrivilegesRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)getPrivilegesRequest.getCatalogId());
            }
            if (getPrivilegesRequest.getPrincipalName() != null) {
                jsonWriter.key("principalName").value((Object)getPrivilegesRequest.getPrincipalName());
            }
            if (getPrivilegesRequest.getPrincipalType() != null) {
                jsonWriter.key("principalType").value((Object)getPrivilegesRequest.getPrincipalType());
            }
            if ((catalogEntity = getPrivilegesRequest.getCatalogEntity()) != null) {
                jsonWriter.key("catalogEntity");
                jsonWriter.object();
                if (catalogEntity.getEntityType() != null) {
                    jsonWriter.key("entityType").value((Object)catalogEntity.getEntityType());
                }
                if (catalogEntity.getNamespaceName() != null) {
                    jsonWriter.key("namespaceName").value((Object)catalogEntity.getNamespaceName());
                }
                if (catalogEntity.getTableName() != null) {
                    jsonWriter.key("tableName").value((Object)catalogEntity.getTableName());
                }
                if (catalogEntity.getPartitionName() != null) {
                    jsonWriter.key("partitionName").value((Object)catalogEntity.getPartitionName());
                }
                if (catalogEntity.getColumnName() != null) {
                    jsonWriter.key("columnName").value((Object)catalogEntity.getColumnName());
                }
                jsonWriter.endObject();
            }
            if (getPrivilegesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value((Object)getPrivilegesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

