/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.GetPartitionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class GetPartitionRequestMarshaller
implements Marshaller<Request<GetPartitionRequest>, GetPartitionRequest> {
    @Override
    public Request<GetPartitionRequest> marshall(GetPartitionRequest getPartitionRequest) {
        if (getPartitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPartitionRequest> request = new DefaultRequest<GetPartitionRequest>(getPartitionRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.GetPartition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag partitionValuesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (getPartitionRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)getPartitionRequest.getCatalogId());
            }
            if (getPartitionRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)getPartitionRequest.getNamespaceName());
            }
            if (getPartitionRequest.getTableName() != null) {
                jsonWriter.key("tableName").value((Object)getPartitionRequest.getTableName());
            }
            if (!((partitionValuesList = (ListWithAutoConstructFlag)getPartitionRequest.getPartitionValues()) == null || partitionValuesList.isAutoConstruct() && partitionValuesList.isEmpty())) {
                jsonWriter.key("partitionValues");
                jsonWriter.array();
                for (String partitionValuesListValue : partitionValuesList) {
                    if (partitionValuesListValue == null) continue;
                    jsonWriter.value((Object)partitionValuesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

