/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.DeletePrivilegesRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.EntityDescription;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.EntityPrivilege;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.PrivilegeGrantInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class DeletePrivilegesRequestMarshaller
implements Marshaller<Request<DeletePrivilegesRequest>, DeletePrivilegesRequest> {
    @Override
    public Request<DeletePrivilegesRequest> marshall(DeletePrivilegesRequest deletePrivilegesRequest) {
        if (deletePrivilegesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeletePrivilegesRequest> request = new DefaultRequest<DeletePrivilegesRequest>(deletePrivilegesRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.DeletePrivileges";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag catalogEntityPrivilegesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (deletePrivilegesRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)deletePrivilegesRequest.getCatalogId());
            }
            if (!((catalogEntityPrivilegesList = (ListWithAutoConstructFlag)deletePrivilegesRequest.getCatalogEntityPrivileges()) == null || catalogEntityPrivilegesList.isAutoConstruct() && catalogEntityPrivilegesList.isEmpty())) {
                jsonWriter.key("catalogEntityPrivileges");
                jsonWriter.array();
                for (EntityPrivilege catalogEntityPrivilegesListValue : catalogEntityPrivilegesList) {
                    PrivilegeGrantInfo grantInfo;
                    if (catalogEntityPrivilegesListValue == null) continue;
                    jsonWriter.object();
                    EntityDescription entityDescription = catalogEntityPrivilegesListValue.getEntityDescription();
                    if (entityDescription != null) {
                        jsonWriter.key("entityDescription");
                        jsonWriter.object();
                        if (entityDescription.getEntityType() != null) {
                            jsonWriter.key("entityType").value((Object)entityDescription.getEntityType());
                        }
                        if (entityDescription.getNamespaceName() != null) {
                            jsonWriter.key("namespaceName").value((Object)entityDescription.getNamespaceName());
                        }
                        if (entityDescription.getTableName() != null) {
                            jsonWriter.key("tableName").value((Object)entityDescription.getTableName());
                        }
                        if (entityDescription.getPartitionName() != null) {
                            jsonWriter.key("partitionName").value((Object)entityDescription.getPartitionName());
                        }
                        if (entityDescription.getColumnName() != null) {
                            jsonWriter.key("columnName").value((Object)entityDescription.getColumnName());
                        }
                        jsonWriter.endObject();
                    }
                    if (catalogEntityPrivilegesListValue.getPrincipalName() != null) {
                        jsonWriter.key("principalName").value((Object)catalogEntityPrivilegesListValue.getPrincipalName());
                    }
                    if (catalogEntityPrivilegesListValue.getPrincipalType() != null) {
                        jsonWriter.key("principalType").value((Object)catalogEntityPrivilegesListValue.getPrincipalType());
                    }
                    if ((grantInfo = catalogEntityPrivilegesListValue.getGrantInfo()) != null) {
                        jsonWriter.key("grantInfo");
                        jsonWriter.object();
                        if (grantInfo.getPrivilege() != null) {
                            jsonWriter.key("privilege").value((Object)grantInfo.getPrivilege());
                        }
                        if (grantInfo.getCreationTime() != null) {
                            jsonWriter.key("creationTime").value(grantInfo.getCreationTime());
                        }
                        if (grantInfo.getGrantorName() != null) {
                            jsonWriter.key("grantorName").value((Object)grantInfo.getGrantorName());
                        }
                        if (grantInfo.getGrantorType() != null) {
                            jsonWriter.key("grantorType").value((Object)grantInfo.getGrantorType());
                        }
                        if (grantInfo.isGrantOption() != null) {
                            jsonWriter.key("grantOption").value((Object)grantInfo.isGrantOption());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (deletePrivilegesRequest.isGrantOption() != null) {
                jsonWriter.key("grantOption").value((Object)deletePrivilegesRequest.isGrantOption());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

