/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.DeletePartitionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class DeletePartitionRequestMarshaller
implements Marshaller<Request<DeletePartitionRequest>, DeletePartitionRequest> {
    @Override
    public Request<DeletePartitionRequest> marshall(DeletePartitionRequest deletePartitionRequest) {
        if (deletePartitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeletePartitionRequest> request = new DefaultRequest<DeletePartitionRequest>(deletePartitionRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.DeletePartition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag partitionValuesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (deletePartitionRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)deletePartitionRequest.getCatalogId());
            }
            if (deletePartitionRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)deletePartitionRequest.getNamespaceName());
            }
            if (deletePartitionRequest.getTableName() != null) {
                jsonWriter.key("tableName").value((Object)deletePartitionRequest.getTableName());
            }
            if (!((partitionValuesList = (ListWithAutoConstructFlag)deletePartitionRequest.getPartitionValues()) == null || partitionValuesList.isAutoConstruct() && partitionValuesList.isEmpty())) {
                jsonWriter.key("partitionValues");
                jsonWriter.array();
                for (String partitionValuesListValue : partitionValuesList) {
                    if (partitionValuesListValue == null) continue;
                    jsonWriter.value((Object)partitionValuesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

