/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Column;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.CreateTableRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Order;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.SerDeInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.SkewedInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.StorageDescriptor;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Table;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    @Override
    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTableRequest> request = new DefaultRequest<CreateTableRequest>(createTableRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.CreateTable";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Table table;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createTableRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)createTableRequest.getCatalogId());
            }
            if (createTableRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)createTableRequest.getNamespaceName());
            }
            if ((table = createTableRequest.getTable()) != null) {
                ListWithAutoConstructFlag partitionKeysList;
                StorageDescriptor storageDescriptor;
                jsonWriter.key("table");
                jsonWriter.object();
                if (table.getName() != null) {
                    jsonWriter.key("name").value((Object)table.getName());
                }
                if (table.getOwner() != null) {
                    jsonWriter.key("owner").value((Object)table.getOwner());
                }
                if (table.getCreateTime() != null) {
                    jsonWriter.key("createTime").value(table.getCreateTime());
                }
                if (table.getLastAccessTime() != null) {
                    jsonWriter.key("lastAccessTime").value(table.getLastAccessTime());
                }
                if (table.getLastAnalyzedTime() != null) {
                    jsonWriter.key("lastAnalyzedTime").value(table.getLastAnalyzedTime());
                }
                if (table.getRetention() != null) {
                    jsonWriter.key("retention").value((Object)table.getRetention());
                }
                if ((storageDescriptor = table.getStorageDescriptor()) != null) {
                    SkewedInfo skewedInfo;
                    ListWithAutoConstructFlag listWithAutoConstructFlag;
                    ListWithAutoConstructFlag listWithAutoConstructFlag2;
                    SerDeInfo serdeInfo;
                    jsonWriter.key("storageDescriptor");
                    jsonWriter.object();
                    ListWithAutoConstructFlag columnsList = (ListWithAutoConstructFlag)storageDescriptor.getColumns();
                    if (!(columnsList == null || columnsList.isAutoConstruct() && columnsList.isEmpty())) {
                        jsonWriter.key("columns");
                        jsonWriter.array();
                        for (Column column : columnsList) {
                            if (column == null) continue;
                            jsonWriter.object();
                            if (column.getName() != null) {
                                jsonWriter.key("name").value((Object)column.getName());
                            }
                            if (column.getType() != null) {
                                jsonWriter.key("type").value((Object)column.getType());
                            }
                            if (column.getComment() != null) {
                                jsonWriter.key("comment").value((Object)column.getComment());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (storageDescriptor.getLocation() != null) {
                        jsonWriter.key("location").value((Object)storageDescriptor.getLocation());
                    }
                    if (storageDescriptor.getInputFormat() != null) {
                        jsonWriter.key("inputFormat").value((Object)storageDescriptor.getInputFormat());
                    }
                    if (storageDescriptor.getOutputFormat() != null) {
                        jsonWriter.key("outputFormat").value((Object)storageDescriptor.getOutputFormat());
                    }
                    if (storageDescriptor.isCompressed() != null) {
                        jsonWriter.key("compressed").value((Object)storageDescriptor.isCompressed());
                    }
                    if (storageDescriptor.getNumberOfBuckets() != null) {
                        jsonWriter.key("numberOfBuckets").value((Object)storageDescriptor.getNumberOfBuckets());
                    }
                    if ((serdeInfo = storageDescriptor.getSerdeInfo()) != null) {
                        jsonWriter.key("serdeInfo");
                        jsonWriter.object();
                        if (serdeInfo.getName() != null) {
                            jsonWriter.key("name").value((Object)serdeInfo.getName());
                        }
                        if (serdeInfo.getSerializationLibrary() != null) {
                            jsonWriter.key("serializationLibrary").value((Object)serdeInfo.getSerializationLibrary());
                        }
                        if (serdeInfo.getParameters() != null) {
                            jsonWriter.key("parameters");
                            jsonWriter.object();
                            for (Map.Entry<String, String> entry : serdeInfo.getParameters().entrySet()) {
                                if (entry.getValue() == null) continue;
                                jsonWriter.key(entry.getKey());
                                jsonWriter.value((Object)entry.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if (!((listWithAutoConstructFlag2 = (ListWithAutoConstructFlag)storageDescriptor.getBucketColumns()) == null || listWithAutoConstructFlag2.isAutoConstruct() && listWithAutoConstructFlag2.isEmpty())) {
                        jsonWriter.key("bucketColumns");
                        jsonWriter.array();
                        for (Object bucketColumnsListValue : listWithAutoConstructFlag2) {
                            if (bucketColumnsListValue == null) continue;
                            jsonWriter.value(bucketColumnsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((listWithAutoConstructFlag = (ListWithAutoConstructFlag)storageDescriptor.getSortColumns()) == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jsonWriter.key("sortColumns");
                        jsonWriter.array();
                        for (Order sortColumnsListValue : listWithAutoConstructFlag) {
                            if (sortColumnsListValue == null) continue;
                            jsonWriter.object();
                            if (sortColumnsListValue.getColumn() != null) {
                                jsonWriter.key("column").value((Object)sortColumnsListValue.getColumn());
                            }
                            if (sortColumnsListValue.getOrder() != null) {
                                jsonWriter.key("order").value((Object)sortColumnsListValue.getOrder());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (storageDescriptor.getParameters() != null) {
                        jsonWriter.key("parameters");
                        jsonWriter.object();
                        for (Map.Entry<String, String> parametersListValue : storageDescriptor.getParameters().entrySet()) {
                            if (parametersListValue.getValue() == null) continue;
                            jsonWriter.key(parametersListValue.getKey());
                            jsonWriter.value((Object)parametersListValue.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    if ((skewedInfo = storageDescriptor.getSkewedInfo()) != null) {
                        ListWithAutoConstructFlag skewedColumnValuesList;
                        jsonWriter.key("skewedInfo");
                        jsonWriter.object();
                        ListWithAutoConstructFlag skewedColumnNamesList = (ListWithAutoConstructFlag)skewedInfo.getSkewedColumnNames();
                        if (!(skewedColumnNamesList == null || skewedColumnNamesList.isAutoConstruct() && skewedColumnNamesList.isEmpty())) {
                            jsonWriter.key("skewedColumnNames");
                            jsonWriter.array();
                            for (String skewedColumnNamesListValue : skewedColumnNamesList) {
                                if (skewedColumnNamesListValue == null) continue;
                                jsonWriter.value((Object)skewedColumnNamesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((skewedColumnValuesList = (ListWithAutoConstructFlag)skewedInfo.getSkewedColumnValues()) == null || skewedColumnValuesList.isAutoConstruct() && skewedColumnValuesList.isEmpty())) {
                            jsonWriter.key("skewedColumnValues");
                            jsonWriter.array();
                            for (String string : skewedColumnValuesList) {
                                if (string == null) continue;
                                jsonWriter.value((Object)string);
                            }
                            jsonWriter.endArray();
                        }
                        if (skewedInfo.getSkewedColumnValueLocationMaps() != null) {
                            jsonWriter.key("skewedColumnValueLocationMaps");
                            jsonWriter.object();
                            for (Map.Entry entry : skewedInfo.getSkewedColumnValueLocationMaps().entrySet()) {
                                if (entry.getValue() == null) continue;
                                jsonWriter.key((String)entry.getKey());
                                jsonWriter.value(entry.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if (storageDescriptor.isStoredAsSubDirectories() != null) {
                        jsonWriter.key("storedAsSubDirectories").value((Object)storageDescriptor.isStoredAsSubDirectories());
                    }
                    jsonWriter.endObject();
                }
                if (!((partitionKeysList = (ListWithAutoConstructFlag)table.getPartitionKeys()) == null || partitionKeysList.isAutoConstruct() && partitionKeysList.isEmpty())) {
                    jsonWriter.key("partitionKeys");
                    jsonWriter.array();
                    for (Column column : partitionKeysList) {
                        if (column == null) continue;
                        jsonWriter.object();
                        if (column.getName() != null) {
                            jsonWriter.key("name").value((Object)column.getName());
                        }
                        if (column.getType() != null) {
                            jsonWriter.key("type").value((Object)column.getType());
                        }
                        if (column.getComment() != null) {
                            jsonWriter.key("comment").value((Object)column.getComment());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if (table.getViewOriginalText() != null) {
                    jsonWriter.key("viewOriginalText").value((Object)table.getViewOriginalText());
                }
                if (table.getViewExpandedText() != null) {
                    jsonWriter.key("viewExpandedText").value((Object)table.getViewExpandedText());
                }
                if (table.getTableType() != null) {
                    jsonWriter.key("tableType").value((Object)table.getTableType());
                }
                if (table.getParameters() != null) {
                    jsonWriter.key("parameters");
                    jsonWriter.object();
                    for (Map.Entry entry : table.getParameters().entrySet()) {
                        if (entry.getValue() == null) continue;
                        jsonWriter.key((String)entry.getKey());
                        jsonWriter.value(entry.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

