/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.CreateRoleRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Role;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    @Override
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRoleRequest> request = new DefaultRequest<CreateRoleRequest>(createRoleRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.CreateRole";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Role role;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createRoleRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)createRoleRequest.getCatalogId());
            }
            if ((role = createRoleRequest.getRole()) != null) {
                jsonWriter.key("role");
                jsonWriter.object();
                if (role.getName() != null) {
                    jsonWriter.key("name").value((Object)role.getName());
                }
                if (role.getCreationTime() != null) {
                    jsonWriter.key("creationTime").value(role.getCreationTime());
                }
                if (role.getOwner() != null) {
                    jsonWriter.key("owner").value((Object)role.getOwner());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

