/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.DefaultRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.Request;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.http.HttpMethodName;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.CreateFunctionRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Function;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.ResourceUri;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Marshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringInputStream;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class CreateFunctionRequestMarshaller
implements Marshaller<Request<CreateFunctionRequest>, CreateFunctionRequest> {
    @Override
    public Request<CreateFunctionRequest> marshall(CreateFunctionRequest createFunctionRequest) {
        if (createFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFunctionRequest> request = new DefaultRequest<CreateFunctionRequest>(createFunctionRequest, "AmazonDataCatalog");
        String target = "AmazonDataCatalog.CreateFunction";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Function function;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createFunctionRequest.getCatalogId() != null) {
                jsonWriter.key("catalogId").value((Object)createFunctionRequest.getCatalogId());
            }
            if (createFunctionRequest.getNamespaceName() != null) {
                jsonWriter.key("namespaceName").value((Object)createFunctionRequest.getNamespaceName());
            }
            if ((function = createFunctionRequest.getFunction()) != null) {
                ListWithAutoConstructFlag resourceUrisList;
                jsonWriter.key("function");
                jsonWriter.object();
                if (function.getFunctionName() != null) {
                    jsonWriter.key("functionName").value((Object)function.getFunctionName());
                }
                if (function.getClassName() != null) {
                    jsonWriter.key("className").value((Object)function.getClassName());
                }
                if (function.getOwnerName() != null) {
                    jsonWriter.key("ownerName").value((Object)function.getOwnerName());
                }
                if (function.getOwnerType() != null) {
                    jsonWriter.key("ownerType").value((Object)function.getOwnerType());
                }
                if (function.getCreateTime() != null) {
                    jsonWriter.key("createTime").value(function.getCreateTime());
                }
                if (!((resourceUrisList = (ListWithAutoConstructFlag)function.getResourceUris()) == null || resourceUrisList.isAutoConstruct() && resourceUrisList.isEmpty())) {
                    jsonWriter.key("resourceUris");
                    jsonWriter.array();
                    for (ResourceUri resourceUrisListValue : resourceUrisList) {
                        if (resourceUrisListValue == null) continue;
                        jsonWriter.object();
                        if (resourceUrisListValue.getResourceType() != null) {
                            jsonWriter.key("resourceType").value((Object)resourceUrisListValue.getResourceType());
                        }
                        if (resourceUrisListValue.getUri() != null) {
                            jsonWriter.key("uri").value((Object)resourceUrisListValue.getUri());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

