/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Partition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetPartitionsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Partition> partitions;
    private String nextToken;

    public List<Partition> getPartitions() {
        if (this.partitions == null) {
            this.partitions = new ListWithAutoConstructFlag();
            this.partitions.setAutoConstruct(true);
        }
        return this.partitions;
    }

    public void setPartitions(Collection<Partition> partitions) {
        if (partitions == null) {
            this.partitions = null;
            return;
        }
        ListWithAutoConstructFlag partitionsCopy = new ListWithAutoConstructFlag(partitions.size());
        partitionsCopy.addAll(partitions);
        this.partitions = partitionsCopy;
    }

    public GetPartitionsResult withPartitions(Partition ... partitions) {
        if (this.getPartitions() == null) {
            this.setPartitions(new ArrayList<Partition>(partitions.length));
        }
        for (Partition value : partitions) {
            this.getPartitions().add(value);
        }
        return this;
    }

    public GetPartitionsResult withPartitions(Collection<Partition> partitions) {
        if (partitions == null) {
            this.partitions = null;
        } else {
            ListWithAutoConstructFlag partitionsCopy = new ListWithAutoConstructFlag(partitions.size());
            partitionsCopy.addAll(partitions);
            this.partitions = partitionsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public GetPartitionsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPartitions() != null) {
            sb.append("Partitions: " + this.getPartitions() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPartitions() == null ? 0 : this.getPartitions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionsResult)) {
            return false;
        }
        GetPartitionsResult other = (GetPartitionsResult)obj;
        if (other.getPartitions() == null ^ this.getPartitions() == null) {
            return false;
        }
        if (other.getPartitions() != null && !other.getPartitions().equals(this.getPartitions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public GetPartitionsResult clone() {
        try {
            return (GetPartitionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

