/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetFunctionsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Function> functions;
    private String nextToken;

    public List<Function> getFunctions() {
        if (this.functions == null) {
            this.functions = new ListWithAutoConstructFlag();
            this.functions.setAutoConstruct(true);
        }
        return this.functions;
    }

    public void setFunctions(Collection<Function> functions) {
        if (functions == null) {
            this.functions = null;
            return;
        }
        ListWithAutoConstructFlag functionsCopy = new ListWithAutoConstructFlag(functions.size());
        functionsCopy.addAll(functions);
        this.functions = functionsCopy;
    }

    public GetFunctionsResult withFunctions(Function ... functions) {
        if (this.getFunctions() == null) {
            this.setFunctions(new ArrayList<Function>(functions.length));
        }
        for (Function value : functions) {
            this.getFunctions().add(value);
        }
        return this;
    }

    public GetFunctionsResult withFunctions(Collection<Function> functions) {
        if (functions == null) {
            this.functions = null;
        } else {
            ListWithAutoConstructFlag functionsCopy = new ListWithAutoConstructFlag(functions.size());
            functionsCopy.addAll(functions);
            this.functions = functionsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public GetFunctionsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctions() != null) {
            sb.append("Functions: " + this.getFunctions() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctions() == null ? 0 : this.getFunctions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionsResult)) {
            return false;
        }
        GetFunctionsResult other = (GetFunctionsResult)obj;
        if (other.getFunctions() == null ^ this.getFunctions() == null) {
            return false;
        }
        if (other.getFunctions() != null && !other.getFunctions().equals(this.getFunctions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public GetFunctionsResult clone() {
        try {
            return (GetFunctionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

