/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.datacatalog.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeletePartitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalogId;
    private String namespaceName;
    private String tableName;
    private ListWithAutoConstructFlag<String> partitionValues;

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public DeletePartitionRequest withCatalogId(String catalogId) {
        this.catalogId = catalogId;
        return this;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public DeletePartitionRequest withNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DeletePartitionRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getPartitionValues() {
        if (this.partitionValues == null) {
            this.partitionValues = new ListWithAutoConstructFlag();
            this.partitionValues.setAutoConstruct(true);
        }
        return this.partitionValues;
    }

    public void setPartitionValues(Collection<String> partitionValues) {
        if (partitionValues == null) {
            this.partitionValues = null;
            return;
        }
        ListWithAutoConstructFlag partitionValuesCopy = new ListWithAutoConstructFlag(partitionValues.size());
        partitionValuesCopy.addAll(partitionValues);
        this.partitionValues = partitionValuesCopy;
    }

    public DeletePartitionRequest withPartitionValues(String ... partitionValues) {
        if (this.getPartitionValues() == null) {
            this.setPartitionValues(new ArrayList<String>(partitionValues.length));
        }
        for (String value : partitionValues) {
            this.getPartitionValues().add(value);
        }
        return this;
    }

    public DeletePartitionRequest withPartitionValues(Collection<String> partitionValues) {
        if (partitionValues == null) {
            this.partitionValues = null;
        } else {
            ListWithAutoConstructFlag partitionValuesCopy = new ListWithAutoConstructFlag(partitionValues.size());
            partitionValuesCopy.addAll(partitionValues);
            this.partitionValues = partitionValuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: " + this.getCatalogId() + ",");
        }
        if (this.getNamespaceName() != null) {
            sb.append("NamespaceName: " + this.getNamespaceName() + ",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getPartitionValues() != null) {
            sb.append("PartitionValues: " + this.getPartitionValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaceName() == null ? 0 : this.getNamespaceName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionValues() == null ? 0 : this.getPartitionValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePartitionRequest)) {
            return false;
        }
        DeletePartitionRequest other = (DeletePartitionRequest)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null) {
            return false;
        }
        if (other.getNamespaceName() != null && !other.getNamespaceName().equals(this.getNamespaceName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getPartitionValues() == null ^ this.getPartitionValues() == null) {
            return false;
        }
        return other.getPartitionValues() == null || other.getPartitionValues().equals(this.getPartitionValues());
    }

    @Override
    public DeletePartitionRequest clone() {
        return (DeletePartitionRequest)super.clone();
    }
}

