/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Order;

@SdkInternalApi
public class OrderMarshaller {
    private static final MarshallingInfo<String> COLUMN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Column").build();
    private static final MarshallingInfo<Integer> ORDERING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ordering").build();
    private static final OrderMarshaller instance = new OrderMarshaller();

    public static OrderMarshaller getInstance() {
        return instance;
    }

    public void marshall(Order order, ProtocolMarshaller protocolMarshaller) {
        if (order == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(order.getColumn(), COLUMN_BINDING);
            protocolMarshaller.marshall(order.getOrdering(), ORDERING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

