/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.SdkClientException;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.ExecutionEngine;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ExecutionEngineMarshaller {
    private static final MarshallingInfo<String> EXECUTIONENGINEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEngineId").build();
    private static final MarshallingInfo<String> EXECUTIONENGINENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEngineName").build();
    private static final MarshallingInfo<String> EXECUTIONENGINEVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEngineVersion").build();
    private static final MarshallingInfo<Map> EXECUTIONENGINEPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEngineProperties").build();
    private static final MarshallingInfo<List> FUNCTIONLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionList").build();
    private static final MarshallingInfo<List> DATATYPELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTypeList").build();
    private static final ExecutionEngineMarshaller instance = new ExecutionEngineMarshaller();

    public static ExecutionEngineMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionEngine executionEngine, ProtocolMarshaller protocolMarshaller) {
        if (executionEngine == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(executionEngine.getExecutionEngineId(), EXECUTIONENGINEID_BINDING);
            protocolMarshaller.marshall(executionEngine.getExecutionEngineName(), EXECUTIONENGINENAME_BINDING);
            protocolMarshaller.marshall(executionEngine.getExecutionEngineVersion(), EXECUTIONENGINEVERSION_BINDING);
            protocolMarshaller.marshall(executionEngine.getExecutionEngineProperties(), EXECUTIONENGINEPROPERTIES_BINDING);
            protocolMarshaller.marshall(executionEngine.getFunctionList(), FUNCTIONLIST_BINDING);
            protocolMarshaller.marshall(executionEngine.getDataTypeList(), DATATYPELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

