/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.DataType;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.transform.Unmarshaller;
import com.amazonaws.athena.jdbc.shaded.jackson.core.JsonToken;

public class DataTypeJsonUnmarshaller
implements Unmarshaller<DataType, JsonUnmarshallerContext> {
    private static DataTypeJsonUnmarshaller instance;

    @Override
    public DataType unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataType dataType = new DataType();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    dataType.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Precision", targetDepth)) {
                    context.nextToken();
                    dataType.setPrecision(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Nullable", targetDepth)) {
                    context.nextToken();
                    dataType.setNullable(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("CaseSensitive", targetDepth)) {
                    context.nextToken();
                    dataType.setCaseSensitive(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Searchable", targetDepth)) {
                    context.nextToken();
                    dataType.setSearchable(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IsUnsigned", targetDepth)) {
                    context.nextToken();
                    dataType.setIsUnsigned(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoIncrementable", targetDepth)) {
                    context.nextToken();
                    dataType.setAutoIncrementable(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("MinimumScale", targetDepth)) {
                    context.nextToken();
                    dataType.setMinimumScale(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("MaximumScale", targetDepth)) {
                    context.nextToken();
                    dataType.setMaximumScale(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dataType;
    }

    public static DataTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataTypeJsonUnmarshaller();
        }
        return instance;
    }
}

