/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform.QueryExecutionStatsMarshaller;
import java.io.Serializable;

public class QueryExecutionStats
implements Serializable,
Cloneable,
StructuredPojo {
    private Long engineExecutionTimeInMillis;
    private Long processedRows;
    private Long processedBytes;
    private Long processedInputRows;
    private Long processedInputBytes;

    public void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
        this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
    }

    public Long getEngineExecutionTimeInMillis() {
        return this.engineExecutionTimeInMillis;
    }

    public QueryExecutionStats withEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
        this.setEngineExecutionTimeInMillis(engineExecutionTimeInMillis);
        return this;
    }

    public void setProcessedRows(Long processedRows) {
        this.processedRows = processedRows;
    }

    public Long getProcessedRows() {
        return this.processedRows;
    }

    public QueryExecutionStats withProcessedRows(Long processedRows) {
        this.setProcessedRows(processedRows);
        return this;
    }

    public void setProcessedBytes(Long processedBytes) {
        this.processedBytes = processedBytes;
    }

    public Long getProcessedBytes() {
        return this.processedBytes;
    }

    public QueryExecutionStats withProcessedBytes(Long processedBytes) {
        this.setProcessedBytes(processedBytes);
        return this;
    }

    public void setProcessedInputRows(Long processedInputRows) {
        this.processedInputRows = processedInputRows;
    }

    public Long getProcessedInputRows() {
        return this.processedInputRows;
    }

    public QueryExecutionStats withProcessedInputRows(Long processedInputRows) {
        this.setProcessedInputRows(processedInputRows);
        return this;
    }

    public void setProcessedInputBytes(Long processedInputBytes) {
        this.processedInputBytes = processedInputBytes;
    }

    public Long getProcessedInputBytes() {
        return this.processedInputBytes;
    }

    public QueryExecutionStats withProcessedInputBytes(Long processedInputBytes) {
        this.setProcessedInputBytes(processedInputBytes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngineExecutionTimeInMillis() != null) {
            sb.append("EngineExecutionTimeInMillis: ").append(this.getEngineExecutionTimeInMillis()).append(",");
        }
        if (this.getProcessedRows() != null) {
            sb.append("ProcessedRows: ").append(this.getProcessedRows()).append(",");
        }
        if (this.getProcessedBytes() != null) {
            sb.append("ProcessedBytes: ").append(this.getProcessedBytes()).append(",");
        }
        if (this.getProcessedInputRows() != null) {
            sb.append("ProcessedInputRows: ").append(this.getProcessedInputRows()).append(",");
        }
        if (this.getProcessedInputBytes() != null) {
            sb.append("ProcessedInputBytes: ").append(this.getProcessedInputBytes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStats)) {
            return false;
        }
        QueryExecutionStats other = (QueryExecutionStats)obj;
        if (other.getEngineExecutionTimeInMillis() == null ^ this.getEngineExecutionTimeInMillis() == null) {
            return false;
        }
        if (other.getEngineExecutionTimeInMillis() != null && !other.getEngineExecutionTimeInMillis().equals(this.getEngineExecutionTimeInMillis())) {
            return false;
        }
        if (other.getProcessedRows() == null ^ this.getProcessedRows() == null) {
            return false;
        }
        if (other.getProcessedRows() != null && !other.getProcessedRows().equals(this.getProcessedRows())) {
            return false;
        }
        if (other.getProcessedBytes() == null ^ this.getProcessedBytes() == null) {
            return false;
        }
        if (other.getProcessedBytes() != null && !other.getProcessedBytes().equals(this.getProcessedBytes())) {
            return false;
        }
        if (other.getProcessedInputRows() == null ^ this.getProcessedInputRows() == null) {
            return false;
        }
        if (other.getProcessedInputRows() != null && !other.getProcessedInputRows().equals(this.getProcessedInputRows())) {
            return false;
        }
        if (other.getProcessedInputBytes() == null ^ this.getProcessedInputBytes() == null) {
            return false;
        }
        return other.getProcessedInputBytes() == null || other.getProcessedInputBytes().equals(this.getProcessedInputBytes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngineExecutionTimeInMillis() == null ? 0 : this.getEngineExecutionTimeInMillis().hashCode());
        hashCode = 31 * hashCode + (this.getProcessedRows() == null ? 0 : this.getProcessedRows().hashCode());
        hashCode = 31 * hashCode + (this.getProcessedBytes() == null ? 0 : this.getProcessedBytes().hashCode());
        hashCode = 31 * hashCode + (this.getProcessedInputRows() == null ? 0 : this.getProcessedInputRows().hashCode());
        hashCode = 31 * hashCode + (this.getProcessedInputBytes() == null ? 0 : this.getProcessedInputBytes().hashCode());
        return hashCode;
    }

    public QueryExecutionStats clone() {
        try {
            return (QueryExecutionStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionStatsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

