/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model;

import com.amazonaws.athena.jdbc.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.transform.CatalogMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Catalog
implements Serializable,
Cloneable,
StructuredPojo {
    private String catalogName;
    private String catalogId;
    private String description;
    private Map<String, String> parameters;

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Catalog withCatalogName(String catalogName) {
        this.setCatalogName(catalogName);
        return this;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public Catalog withCatalogId(String catalogId) {
        this.setCatalogId(catalogId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Catalog withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Catalog withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Catalog addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Catalog clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogName() != null) {
            sb.append("CatalogName: ").append(this.getCatalogName()).append(",");
        }
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: ").append(this.getCatalogId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Catalog)) {
            return false;
        }
        Catalog other = (Catalog)obj;
        if (other.getCatalogName() == null ^ this.getCatalogName() == null) {
            return false;
        }
        if (other.getCatalogName() != null && !other.getCatalogName().equals(this.getCatalogName())) {
            return false;
        }
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogName() == null ? 0 : this.getCatalogName().hashCode());
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public Catalog clone() {
        try {
            return (Catalog)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CatalogMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

