/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TimeLog {
    private static final int NANO_TO_MS = 1000000;
    private static final Logger LOGGER = LogManager.getLogger(AthenaStatement.class);
    List<Observation> observations = new ArrayList<Observation>();

    public TimeLog() {
        this.addObservation("Timelog created");
    }

    public void addObservation(String name) {
        if (LOGGER.isDebugEnabled()) {
            this.observations.add(new Observation(name, System.nanoTime()));
        }
    }

    public void addFinalObservation(String name) {
        this.addObservation(name);
        this.printObservations();
    }

    public void printObservations() {
        if (this.observations.isEmpty()) {
            return;
        }
        long startingTimeStamp = this.observations.get(0).getTimeStamp();
        for (Observation observation : this.observations) {
            LOGGER.debug("Event Message: " + observation.getObservationName() + " : " + this.prettyPrintTime(observation.timeStampInNano - startingTimeStamp));
        }
    }

    private String prettyPrintTime(long durationLength) {
        return "" + durationLength / 1000000L + " ms";
    }

    public static class Observation {
        private String observationName;
        private long timeStampInNano;

        public Observation(String observationName, long timeStampInNano) {
            this.observationName = observationName;
            this.timeStampInNano = timeStampInNano;
        }

        public String getObservationName() {
            return this.observationName;
        }

        public long getTimeStamp() {
            return this.timeStampInNano;
        }
    }
}

