/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignatureParameter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class ColumnInfo {
    private static final Logger LOGGER = LogManager.getLogger(ColumnInfo.class);
    public static final int CHAR_SIZE = 2;
    public static final int VARCHAR_MAX = 0x40000000;
    public static final int VARBINARY_MAX = 0x40000000;
    private static final int TIME_ZONE_MAX = 40;
    private static final int TIME_MAX = "HH:mm:ss.SSS".length();
    private static final int TIME_WITH_TIME_ZONE_MAX = TIME_MAX + 40;
    private static final int TIMESTAMP_MAX = "yyyy-MM-dd HH:mm:ss.SSS".length();
    private static final int TIMESTAMP_WITH_TIME_ZONE_MAX = TIMESTAMP_MAX + 40;
    private static final int DATE_MAX = "yyyy-MM-dd".length();
    private final int sqlColumnType;
    private final List<Integer> columnParameterTypes;
    private final TypeSignature columnTypeSignature;
    private final int nullable;
    private final boolean currency;
    private final boolean signed;
    private final int precision;
    private final int scale;
    private final int columnDisplaySize;
    private final String columnLabel;
    private final String columnName;
    private final String tableName;
    private final String schemaName;
    private final String catalogName;
    private final boolean caseSensitive;
    private final Integer numPrecRadix;

    public ColumnInfo(int sqlColumnType, List<Integer> columnParameterTypes, TypeSignature columnTypeSignature, Integer nullable, boolean currency, boolean signed, int precision, int scale, int columnDisplaySize, String columnLabel, String columnName, String tableName, String schemaName, String catalogName, boolean caseSensitive, Integer numPrecRadix) {
        this.sqlColumnType = sqlColumnType;
        this.columnParameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnParameterTypes, "columnParameterTypes is null"));
        this.columnTypeSignature = Objects.requireNonNull(columnTypeSignature, "columnTypeName is null");
        this.nullable = Objects.requireNonNull(nullable, "nullable is null");
        this.currency = currency;
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.columnDisplaySize = columnDisplaySize;
        this.columnLabel = Objects.requireNonNull(columnLabel, "columnLabel is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.caseSensitive = caseSensitive;
        this.numPrecRadix = numPrecRadix;
    }

    public static void setTypeInfo(Builder builder, TypeSignature type) {
        int sqlDataType = ColumnInfo.convertDataTypeStringToSQL(type);
        builder.setColumnType(sqlDataType);
        ImmutableList.Builder parameterTypes = ImmutableList.builder();
        for (TypeSignatureParameter parameter : type.getParameters()) {
            parameterTypes.add((Object)ColumnInfo.getType(parameter));
        }
        builder.setColumnParameterTypes((List<Integer>)((Object)parameterTypes.build()));
        builder.setColumnTypeSignature(type);
        builder.setNumPrecRadix(ColumnInfo.calculateNumPrecRadix(sqlDataType));
        switch (type.getBase()) {
            case "boolean": {
                builder.setColumnDisplaySize(5);
                break;
            }
            case "bigint": {
                builder.setSigned(true);
                builder.setPrecision(19);
                builder.setScale(0);
                builder.setColumnDisplaySize(20);
                break;
            }
            case "integer": 
            case "int": {
                builder.setSigned(true);
                builder.setPrecision(10);
                builder.setScale(0);
                builder.setColumnDisplaySize(11);
                break;
            }
            case "smallint": {
                builder.setSigned(true);
                builder.setPrecision(5);
                builder.setScale(0);
                builder.setColumnDisplaySize(6);
                break;
            }
            case "tinyint": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(4);
                break;
            }
            case "double": {
                builder.setSigned(true);
                builder.setPrecision(17);
                builder.setScale(0);
                builder.setColumnDisplaySize(24);
                break;
            }
            case "char": {
                if (type.getParameters() != null && !type.getParameters().isEmpty()) {
                    int size = type.getParameters().get(0).getLongLiteral().intValue();
                    builder.setPrecision(size);
                    builder.setColumnDisplaySize(size);
                } else {
                    builder.setPrecision(1);
                    builder.setColumnDisplaySize(1);
                }
                builder.setScale(0);
                builder.setCaseSensitive(true);
                break;
            }
            case "varchar": 
            case "string": {
                builder.setSigned(true);
                if (type.getParameters() != null && !type.getParameters().isEmpty()) {
                    int size = type.getParameters().get(0).getLongLiteral().intValue();
                    builder.setPrecision(size);
                    builder.setColumnDisplaySize(size);
                } else {
                    builder.setPrecision(0x40000000);
                    builder.setColumnDisplaySize(0x40000000);
                }
                builder.setScale(0);
                builder.setCaseSensitive(true);
                break;
            }
            case "varbinary": {
                builder.setSigned(true);
                builder.setPrecision(0x40000000);
                builder.setScale(0);
                builder.setColumnDisplaySize(0x40000000);
                break;
            }
            case "time": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIME_MAX);
                break;
            }
            case "time with time zone": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIME_WITH_TIME_ZONE_MAX);
                break;
            }
            case "timestamp": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "timestamp with time zone": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIMESTAMP_WITH_TIME_ZONE_MAX);
                break;
            }
            case "date": {
                builder.setSigned(true);
                builder.setScale(0);
                builder.setColumnDisplaySize(DATE_MAX);
                break;
            }
            case "interval year to month": {
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "interval day to second": {
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "decimal": {
                builder.setSigned(true);
                if (type.getParameters() == null || type.getParameters().size() <= 0) break;
                int precision = type.getParameters().get(0).getLongLiteral().intValue();
                builder.setPrecision(precision);
                if (type.getParameters().size() > 1) {
                    int scale = type.getParameters().get(1).getLongLiteral().intValue();
                    builder.setScale(scale);
                    builder.setColumnDisplaySize(precision + scale + 2);
                    break;
                }
                builder.setScale(0);
                builder.setColumnDisplaySize(precision + 2);
            }
        }
    }

    private static Integer calculateNumPrecRadix(int sqlDataType) {
        switch (sqlDataType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 10;
            }
            case 6: 
            case 7: {
                return 2;
            }
        }
        return null;
    }

    private static int getType(TypeSignatureParameter typeParameter) {
        switch (typeParameter.getKind()) {
            case TYPE: {
                return ColumnInfo.convertDataTypeStringToSQL(typeParameter.getTypeSignature().getBase());
            }
        }
        return 2000;
    }

    public static int convertDataTypeStringToSQL(String type) {
        TypeSignature typeSignature = TypeSignature.parseTypeSignature(type);
        return ColumnInfo.convertDataTypeStringToSQL(typeSignature);
    }

    public static int convertDataTypeStringToSQL(TypeSignature type) {
        switch (type.getBase().toLowerCase()) {
            case "boolean": {
                return 16;
            }
            case "bigint": {
                return -5;
            }
            case "integer": 
            case "int": {
                return 4;
            }
            case "smallint": {
                return 5;
            }
            case "tinyint": {
                return -6;
            }
            case "double": {
                return 8;
            }
            case "varchar": 
            case "string": {
                return -16;
            }
            case "char": {
                return 1;
            }
            case "varbinary": {
                return -4;
            }
            case "time": {
                return 92;
            }
            case "time with time zone": {
                return 92;
            }
            case "timestamp": 
            case "timestamp with time zone": {
                return 93;
            }
            case "date": {
                return 91;
            }
            case "decimal": {
                return 3;
            }
            case "float": {
                return 6;
            }
            case "array": {
                return 2003;
            }
            case "struct": {
                return 2002;
            }
        }
        return 2000;
    }

    public int getSQLColumnType() {
        return this.sqlColumnType;
    }

    public List<Integer> getColumnParameterTypes() {
        return this.columnParameterTypes;
    }

    public String getColumnTypeName() {
        return this.columnTypeSignature.getBase();
    }

    public TypeSignature getColumnTypeSignature() {
        return this.columnTypeSignature;
    }

    public int isNullable() {
        return this.nullable;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public static Builder buildSimpleColumnInfoBuilder(String columnName, String columnTypeString) {
        Builder builder = new Builder().setColumnName(columnName).setColumnLabel(columnName).setSchemaName("").setCatalogName("").setTableName("");
        ColumnInfo.setTypeInfo(builder, TypeSignature.parseTypeSignature(columnTypeString));
        return builder;
    }

    public Integer getNumPrecRadix() {
        return this.numPrecRadix;
    }

    static class Builder {
        private int columnType;
        private List<Integer> columnParameterTypes;
        private TypeSignature columnTypeSignature;
        private int nullable;
        private boolean currency;
        private boolean signed;
        private int precision;
        private int scale;
        private int columnDisplaySize;
        private String columnLabel;
        private String columnName;
        private String tableName;
        private String schemaName;
        private String catalogName;
        private boolean caseSensitive;
        private Integer numPrecRadix;

        Builder() {
        }

        public Builder setColumnInfo(ColumnInfo info) {
            this.columnType = info.getSQLColumnType();
            this.columnParameterTypes = info.getColumnParameterTypes();
            this.columnTypeSignature = info.getColumnTypeSignature();
            this.nullable = info.isNullable();
            this.currency = info.isCurrency();
            this.signed = info.isSigned();
            this.precision = info.getPrecision();
            this.scale = info.getScale();
            this.columnDisplaySize = info.getColumnDisplaySize();
            this.columnLabel = info.getColumnLabel();
            this.columnName = info.getColumnName();
            this.tableName = info.getTableName();
            this.schemaName = info.getSchemaName();
            this.catalogName = info.getCatalogName();
            this.caseSensitive = info.isCaseSensitive();
            this.numPrecRadix = info.getNumPrecRadix();
            return this;
        }

        public Builder setColumnType(int columnType) {
            this.columnType = columnType;
            return this;
        }

        public Builder setColumnParameterTypes(List<Integer> columnParameterTypes) {
            this.columnParameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnParameterTypes, "columnParameterTypes is null"));
            return this;
        }

        public Builder setColumnTypeSignature(TypeSignature columnTypeSignature) {
            this.columnTypeSignature = columnTypeSignature;
            return this;
        }

        public Builder setNullable(int nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setCurrency(boolean currency) {
            this.currency = currency;
            return this;
        }

        public Builder setSigned(boolean signed) {
            this.signed = signed;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder setColumnDisplaySize(int columnDisplaySize) {
            this.columnDisplaySize = columnDisplaySize;
            return this;
        }

        public Builder setColumnLabel(String columnLabel) {
            this.columnLabel = columnLabel;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder setNumPrecRadix(Integer precRadix) {
            this.numPrecRadix = precRadix;
            return this;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this.columnType, this.columnParameterTypes, this.columnTypeSignature, this.nullable, this.currency, this.signed, this.precision, this.scale, this.columnDisplaySize, this.columnLabel, this.columnName, this.tableName, this.schemaName, this.catalogName, this.caseSensitive, this.numPrecRadix);
        }
    }
}

